/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.lib.chat.message;

import java.util.Iterator;
import net.creeperhost.minetogether.lib.chat.message.EmptyMessageComponent;
import net.creeperhost.minetogether.lib.chat.message.ProfileMessageComponent;
import net.creeperhost.minetogether.lib.chat.message.StringMessageComponent;
import net.creeperhost.minetogether.lib.chat.profile.Profile;
import net.creeperhost.minetogether.lib.util.AbstractWeakNotifiable;
import org.jetbrains.annotations.Nullable;

public abstract class MessageComponent
extends AbstractWeakNotifiable<MessageComponent> {
    public static final MessageComponent MESSAGE_DELETED = MessageComponent.of("<message deleted>");
    @Nullable
    protected MessageComponent prev;
    @Nullable
    protected MessageComponent next;

    public abstract String getMessage();

    public static MessageComponent of() {
        return new EmptyMessageComponent();
    }

    public static MessageComponent of(String text) {
        return new StringMessageComponent(text);
    }

    public static MessageComponent of(Profile profile) {
        return new ProfileMessageComponent(profile);
    }

    public MessageComponent append(String text) {
        return this.append(MessageComponent.of(text));
    }

    public MessageComponent append(Profile profile) {
        return this.append(MessageComponent.of(profile));
    }

    public MessageComponent append(MessageComponent other) {
        assert (other.prev == null) : "Cannot move components between trees";
        assert (this.prev == null) : "Must call append on the root message component.";
        MessageComponent last = this;
        while (last.next != null) {
            assert (last != other) : "Already added";
            last = last.next;
        }
        other.prev = last;
        last.next = other;
        other.addListener(other.prev, (i, e) -> i.fire(i));
        return this;
    }

    public boolean isEmpty() {
        return false;
    }

    public Iterable<MessageComponent> iterate() {
        return () -> new Iterator<MessageComponent>(){
            @Nullable
            private MessageComponent pointer;
            {
                this.pointer = MessageComponent.this;
            }

            @Override
            public boolean hasNext() {
                return this.pointer != null;
            }

            @Override
            public MessageComponent next() {
                assert (this.pointer != null);
                MessageComponent ret = this.pointer;
                do {
                    this.pointer = this.pointer.next;
                } while (this.pointer != null && this.pointer.isEmpty());
                return ret;
            }
        };
    }

    public String toString() {
        String result = this.getMessage();
        if (this.next != null) {
            return result + this.next;
        }
        return result;
    }
}

